 ; Ŀ
 ;   Squid - Adjust attribute widths in the monster shutdown key block.    
 ;   Copyright 1997, 2002, 2003, 2004, 2005, 2008 by Rocket Software Ltd.  
 ;   Thanks for all the sepia.                                             
 ; 

 ; Ŀ
 ;   Enco - find the correct width for an attribute.                       
 ;   This is for the strange Encana COntact Automation SDK.                
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN ENCO (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((member tagnam '("B1" "B2" "B3" "B4"))
         (setq wid 137))
        ((or (member tagnam '("B5" "C5" "D5" "E5" "F5"))
             (= second 7)
             (member first '("H" "I" "J")))
         (setq wid 20))
        ((member tagnam '("B6" "C6" "D6" "E6" "F6"))
         (setq wid 66))
        ((member first '("B" "C" "D" "E" "F"))
         (setq wid 10))
        ((= first "G")
         (setq wid 119))
        ((= first "K")
         (setq wid 36))
        ((or (= first "L")
             (= second 5))
         (setq wid 28))
        ((= second 6)
         (setq wid 58))
        (t (setq wid 5)))
 wid)
 ; Ŀ
 ;   Enco end.                                                             
 ; 

 ; Ŀ
 ;   Ephira - find the correct width for an attribute.                     
 ;   This is for Abdul's latest Encana SDK, which came from an existing    
 ;   drawing and is not his fault.                                         
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN EPHIRA (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((member tagnam '("A1" "B1" "C1" "D1" "E1" "F1"))
         (setq wid 116))
        ((member tagnam '("J2" "J3" "J4" "J5"))
         (setq wid 64))
        ((= first "A")
         (setq wid 7))
        ((or (member first '("B" "C" "D" "E" "F"))
             (member second '(1 2 3 4 5)))
         (setq wid 9))
        ((= first "G")
         (setq wid 22))
        ((= first "H")
         (setq wid 100))
        ((= first "I")
         (setq wid 35))
        ((= first "J")
         (setq wid 23))
        ((or (member first '("K" "L"))
             (= second 8))
         (setq wid 21))
        ((= second 6)
         (setq wid 18))
 ; Ŀ
 ;   Line seven has alternating long and short space lengths.  Even        
 ;   letters are long, odds short, based on the last digit of the string.  
 ; 
        ((= second 7)
         (setq thechr (substr first (strlen first)))
         (setq ascval (/ (ascii thechr) 2.0))
         (if (= ascval (fix ascval))
             (setq wid 44)
             (setq wid 63)))
 ; Ŀ
 ;   The default - the main grid area - is 12 wide, with clearance = 9.    
 ; 
        (t (setq wid 9)))
 wid)
 ; Ŀ
 ;   Ephira end.                                                           
 ; 

 ; Ŀ
 ;   Rrange - find the correct width for an attribute.                     
 ;   This is for the Rangeland block.                                      
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN RRANGE (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (= first "A") (= second 1))
         (setq wid 8))
        ((or (= first "B") (= first "D") (= first "F")
             (= second 2) (= second 4) (= second 6))
         (setq wid 21))
        ((or (= first "C") (= second 3))
         (setq wid 100))
        ((or (= first "E") (= second 5))
         (setq wid 33))
        ((or (= first "G") (= second 7))
         (setq wid 12))
        (t (setq wid 3.5)))
 wid)
 ; Ŀ
 ;   Rrange end.                                                           
 ; 

 ; Ŀ
 ;   Nusuk - find the correct width for an attribute.                      
 ;   This is for the latest absolutely final this time and no exceptions   
 ;   we mean it now Gemini SDK block.  Really.                             
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN NUSUK (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((= first "A")
         (setq wid 109))
        ((= second 1)
         (setq wid 97))
        ((or (= first "B") (= first "C") (= second 2) (= second 3))
         (setq wid 9))
        ((or (= first "D") (= first "E") (= second 4) (= second 5))
         (setq wid 22))
        (t (setq wid 6)))
 wid)
 ; Ŀ
 ;   Nusuk end.                                                            
 ; 

 ; Ŀ
 ;   Pukka - find the correct width for an attribute.                      
 ;   This is the default width calculator for the majority of sdk blocks.  
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN PUKKA (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((and (or (= first "A") (= first "B") (= first "C")
                  (= first "D") (= first "E"))
              (= second 1))
         (setq wid 144))
        ((and (= first "K") (<= second 5))
         (setq wid 62))
        ((and (= first "K") (<= second 6))
         (setq wid 89))
        ((= first "A")
         (setq wid 6))
        ((or (= first "B") (= first "C") (= first "D") (= first "E"))
         (setq wid 9))
        ((= first "F")
         (setq wid 17))
        ((= first "G")
         (setq wid 118))
        ((= first "H")
         (setq wid 60))
        ((= first "I")
         (if (member second '(1 2 3 4 5))
             (setq wid 62)
             (setq wid 21)))
        ((= first "J")
         (setq wid 50))
 ; Even letters are long, odds short, based on the last digit of the string.
        ((= second 6)
         (setq thechr (substr first (strlen first)))
         (setq ascval (/ (ascii thechr) 2.0))
         (if (= ascval (fix ascval))
             (setq wid 73)
             (setq wid 22)))
        ((= second 7)
         (setq wid 48))
        ((= second 8)
         (setq wid 37))
        (t (setq wid 9)))
 wid)
 ; Ŀ
 ;   Pukka end.                                                            
 ; 

 ; Ŀ
 ;   Aldr - find the correct width for an attribute in Oi's new            
 ;   Alderson System 1 shutdown key for Penn West.                         
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN ALDR (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((and (member first '("A" "B" "C" "D" "E")) (= second 1))
         (setq wid 64))
        ((and (= first "I") (<= second 5))
         (setq wid 62))
        ((= first "A")
         (setq wid 8))
        ((member first (list "B" "C" "D" "E"))
         (setq wid 10.5))
        ((= first "F")
         (setq wid 23))
        ((= first "G")
         (setq wid 75))
        ((= first "H")
         (setq wid 40))
        ((and (= first "K") (<= second 6))
         (setq wid 65))
        ((or (member first (list "I" "J" "K"))
             (member second (list 8 9)))
         (setq wid 22))
        ((= second 6)   ; there is no row 7 - it and 6 are combined
         (setq wid 65))
        (t (setq wid 11)))
 wid)
 ; Ŀ
 ;   Aldr end.                                                             
 ; 

 ; Ŀ
 ;   Fistr - find the correct width for an attribute in Steve's            
 ;   absolutely last new shutdown key for Penn West.                       
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN FISTR (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (member first (list "A" "B" "C" "D" "E" "K"))
             (= second 1))
         (setq wid 8))
        ((= first "F")
         (setq wid 25))
        ((= first "G")
         (setq wid 75))
        ((= first "H")
         (setq wid 40))
        ((= first "I")
         (setq wid 23))
        ((= first "J")
         (setq wid 11))
        ((= first "K")
         (setq wid 8))
        ((= first "L")
         (setq wid 22))
        ((= second 2)
         (setq wid 17))
        ((= second 3)
         (setq wid 71))
        ((= second 4)
         (setq wid 27))
        ((= second 5)
         (setq wid 21))
        (t (setq wid 8)))
 wid)
 ; Ŀ
 ;   Fistr end.                                                            
 ; 

 ; Ŀ
 ;   Sepia - find the correct width for an attribute in a new PCP          
 ;   (Encana) shutdown key block.                                          
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN SEPIA (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (member first (list "B" "C" "D" "E" "F" "G"))
             (member second (list 1 2 3 6)))
         (setq wid 10))
        ((= second 4)
         (setq wid 61))
        ((= second 5)
         (setq wid 17))
        ((= first "A")
         (setq wid 7))
        ((= first "H")
         (setq wid 21))
        ((= first "I")
         (setq wid 62))
        ((= first "J")
         (setq wid 48))
        ((= first "K")
         (setq wid 22))
        ((= first "L")
         (setq wid 12))
        ((= first "M")
         (setq wid 13))
        (t (setq wid 10)))
 wid)
 ; Ŀ
 ;   Sepia end.                                                            
 ; 

 ; Ŀ
 ;   Bcgsuk - find the correct width for a Bc Gas SDK attribute.           
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN BCGSUK (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (= first "A") (= second 1))
         (setq wid 90))
        ((or (= first "B") (= first "C") (= second 2) (= second 3))
         (setq wid 8))
        ((or (= first "D") (= first "E") (= second 4) (= second 5))
         (setq wid 22))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   Bcgsuk end.                                                           
 ; 

 ; Ŀ
 ;   Pucker - find the correct width for an attribute.                     
 ;   This is the default width calculator for the majority of sdk blocks.  
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN PUCKER (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((and (or (= first "A") (= first "B") (= first "C")
                  (= first "D") (= first "E"))
              (= second 1))
         (setq wid 144))
        ((and (= first "K") (<= second 5))
         (setq wid 62))
        ((and (= first "K") (<= second 6))
         (setq wid 89))
        ((= first "A")
         (setq wid 6))
        ((or (= first "B") (= first "C") (= first "D") (= first "E"))
         (setq wid 9))
        ((= first "F")
         (setq wid 22))
        ((= first "G")
         (setq wid 80))
        ((= first "H")
         (setq wid 36))
        ((= first "I")
         (if (member second '(1 2 3 4 5))
             (setq wid 62)
             (setq wid 35)))
        ((= first "J")
         (setq wid 19))
 ; Even letters are long, odds short, based on the last digit of the string.
        ((= second 6)
         (setq thechr (substr first (strlen first)))
         (setq ascval (/ (ascii thechr) 2.0))
         (if (= ascval (fix ascval))
             (setq wid 89)
             (setq wid 42)))
        ((= second 7)     ; ok
         (setq wid 42))
        ((or (= second 6) (= second 8))
         (setq wid 42))
        (t (setq wid 9)))
 wid)
 ; Ŀ
 ;   Pucker end.                                                           
 ; 

 ; Ŀ
 ;   Suck0 - find the correct width for an attribute.                      
 ;   This is the default width calculator for the majority of sdk blocks.  
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN SUCK0 (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (= first "A") (= second 1))
         (setq wid 90))
        ((or (= first "B") (= first "C") (= first "D")
             (= second 2) (= second 3) (= second 4))
         (setq wid 22))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   Suck0 end.                                                            
 ; 

 ; Ŀ
 ;   Snucker - find the correct width for an attribute.                    
 ;   This is for the possibly one-off 1out1in-snow Snowdon Tempest Sdk.    
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN SNUCKER (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((= first "A")
         (setq wid 92))
        ((= second 3)
         (setq wid 70))
        ((or (= first "B") (= first "C")
             (= second 4) (= second 5))
         (setq wid 22))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   Snucker end.                                                          
 ; 

 ; Ŀ
 ;   Suctu - find the correct width for an attribute in a Tutu_1-1 block.  
 ;   Takes one argument: Tagnam, an attribute tag                          
 ;   Returns a real (the width).                                           
 ; 
 (DEFUN SUCTU (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (= first "A") (= second 1))
         (setq wid 106))
        ((or (= first "B") (= first "C")
             (= second 2) (= second 3))
         (setq wid 28))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   Suctu end.                                                            
 ; 

 ; Ŀ
 ;   Sucker1 - find the correct width for an attribute.                    
 ;   This is for the original Kilowatts SDK which the committee rejected   
 ;   and is included here just in case.                                    
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN SUCKER1 (tagnam / tlist first second wid)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (= tagnam "A3") (= tagnam "C1"))
         (setq wid 136))
        ((or (= first "A") (= first "B") (= second 1) (= second 2))
         (setq wid 76))
        ((or (= first "C") (= second 3))
         (setq wid 102))
        ((or (= first "D") (= second 4))
         (setq wid 13))
        ((or (= first "E") (= second 5))
         (setq wid 18))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   Sucker1 end.                                                          
 ; 

 ; Ŀ
 ;   Sucker2 - find the correct width for an attribute.                    
 ;   This is for the latest (more-or-less standard) Kilowatts SDK.         
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN SUCKER2 (tagnam / tlist first second wid)
  (setq pos 1)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((= first "A")
         (setq wid 118))
        ((= second 1)
         (setq wid 80))
        ((or (= first "B") (= first "C") (= first "D")
             (= second 2) (= second 3) (= second 4))
         (setq wid 22))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   Sucker2 end.                                                          
 ; 

 ; Ŀ
 ;   RigSuk - find the correct width for an attribute.                     
 ;   This is for a Rigel SDK.                                              
 ;   Takes one argument, an attribute tag, returns a real (the width).     
 ; 
 (DEFUN RIGSUK (tagnam / tlist first second wid)
  (setq tlist (krak tagnam))
  (setq first (car tlist))
  (setq second (read (cadr tlist)))
  (cond ((or (= first "B") (= first "C") (= first "E") (= first "F")
             (= second 6) (= second 7))
         (setq wid 23))
        ((or (= first "D") (= second 5))
         (setq wid 115))
        (t (setq wid 4)))
 wid)
 ; Ŀ
 ;   RigSuk end.                                                           
 ; 

 ; Ŀ
 ;   Krak - divide a string into letters and numbers.                      
 ;   Takes one argument, a string, returns a list of two strings.          
 ; 
 (DEFUN KRAK (str / pos p1 p2)
  (setq pos 1)
  (while (and (>= (strlen str) pos)
              (= (type (read (substr str pos 1))) 'SYM))
         (setq pos (1+ pos)))
  (setq p1 (substr str 1 (1- pos)))
  (setq p2 (substr str pos))
 (list p1 p2))
 ; Ŀ
 ;   Krak end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Tentac - squeeze or stretch attributes as required.        
 ;   Takes two arguments: a block ename and scale.                         
 ; 
 (DEFUN TENTAC (enam blscal / esav entt enam num sublst namp width realwd
                                                          scalfc widscl prev41)
  (setq num 0)
  (setq esav enam)
 ; Ŀ
 ;   Repeat until come to the block end marker.                            
 ; 
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
                                                                   "SEQEND")
         (grtext -2 (itoa (setq num (1+ num))))
 ; Ŀ
 ;   Get attribute name.                                                   
 ; 
         (setq namm (cdr (assoc 2 entt)))
 ; Ŀ
 ;   Call Sucker to find the desired width for the atribute.               
 ; 
         (setq width (* blscal (sucker namm)))
         (setq txtscl 0.85)
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
         (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
         (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ; 
         (if (and (> realwd width)
             (not (equal realwd width 0.1)))
 ; Ŀ
 ;   If the actual width is greater than the allowed width in the          
 ;   sublist, then adjust the width scale factor to make it fit.           
 ;   Wait: must also check to see if the width scale is greater than the   
 ;   ideal - if the attribute is too wide and the width scale is too       
 ;   large, then shrinking the attribute to fit may result in it just      
 ;   filling the space but still being too wide.                           
 ; 
             (progn
 ; Ŀ
 ;   Compare the actual width scale to the ideal width scale.              
 ; 
                  (if (<= widscl txtscl)
 ; Ŀ
 ;   If the actual is less than or equal to the ideal, then make it fit.   
 ; 
                      (progn
                           (setq scalfc (/ width realwd))
                           (setq widscl (* widscl scalfc))
                           (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   If the actual width scale is greater than the ideal, see if the       
 ;   attribute will be too wide if if set to the ideal.                    
 ;   If so then squash to fit, if not then set to the ideal.               
 ; 
                      (progn
                           (if (> (* realwd (/ txtscl widscl)) width)
 ; Ŀ
 ;   Squash to fit.                                                        
 ; 
                               (progn
                                    (setq scalfc (/ width realwd))
                                    (setq widscl (* widscl scalfc))
                                    (entmod (subst (cons 41 widscl)
                                                    prev41 entt)))
 ; Ŀ
 ;   Set to the ideal width scale factor.                                  
 ; 
                               (entmod (subst (cons 41 txtscl)
                                                prev41 entt))))))
 ; Ŀ
 ;   Else the actual width is narrower than or equal to the available      
 ;   space.                                                                
 ; 
             (progn
 ; Ŀ
 ;   See if the attribute is narrower than it should be - if setting the   
 ;   width scale factor to the desired value would leave the attribute     
 ;   wider than the allowable space, then increase it to fill the space.   
 ; 
                  (if (> (* realwd (/ txtscl widscl)) width)
                         (progn
                              (setq scalfc (/ width realwd))
                              (setq widscl (* widscl scalfc))
                              (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
                         (progn
                              (entmod (subst (cons 41 txtscl)
                                             prev41 entt)))))))
  (entupd esav)
 (princ))
 ; Ŀ
 ;   Tentac end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of an attribute.                     
 ;   Takes one argument: the attribute entity data list.  Returns a width. 
 ; 
 (DEFUN WITS (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Squid.                                                                
 ; 
 (DEFUN C:SQUID (/ s t1 ss sucker enam blscal t2)
  (setvar "cmdecho" 0)
  (command "undo" "M")
 ; Ŀ
 ;   Start the timer.                                                      
 ; 
  (setq s (getvar "date"))
  (setq t1 (* 86400.0 (- s (fix s))))                ; start time for timer
 ; Ŀ
 ;   Find an Sdk block, decide which width subroutine to use.              
 ; 
  (cond ((or (setq ss (ssget "X" (list (cons 2 "OUT1IN1"))))
             (setq ss (ssget "X" (list (cons 2 "OUT1IN2"))))
             (setq ss (ssget "X" (list (cons 2 "OUT2IN1"))))
             (setq ss (ssget "X" (list (cons 2 "OUT2IN2"))))
             (setq ss (ssget "X" (list (cons 2 "OUT3IN1"))))
             (setq ss (ssget "X" (list (cons 2 "OUT3IN2"))))
             (setq ss (ssget "X" (list (cons 2 "IN1OUT1"))))
             (setq ss (ssget "X" (list (cons 2 "IN2OUT1"))))
             (setq ss (ssget "X" (list (cons 2 "IN3OUT1"))))
             (setq ss (ssget "X" (list (cons 2 "IN4OUT1"))))
             (setq ss (ssget "X" (list (cons 2 "IN5OUT1"))))
             (setq ss (ssget "X" (list (cons 2 "1IN1OUT-PCP"))))
             (setq ss (ssget "X" (list (cons 2 "2IN1OUT-PCP"))))
             (setq ss (ssget "X" (list (cons 2 "Tutu_1-1"))))
             (setq ss (ssget "X" (list (cons 2 "Tutu_2-1")))))
         (setq sucker suck0))
        ((setq ss (ssget "X" (list (cons 2 "Pfister*"))))
         (setq sucker fistr))
        ((setq ss (ssget "X" (list (cons 2 "Ald-in*out*"))))
         (setq sucker aldr))
        ((setq ss (ssget "X" (list (cons 2 "Pcp3-in*out*"))))
         (setq sucker pucker))
        ((setq ss (ssget "X" (list (cons 2 "Pcp4-in*out*"))))
         (setq sucker pukka))
        ((setq ss (ssget "X" (list (cons 2 "Pcp-in*out*"))))
         (setq sucker sepia))
        ((setq ss (ssget "X" (list (cons 2 "Encana x In*-Out*"))))
         (setq sucker ephira))
        ((setq ss (ssget "X" (list (cons 2 "Out1In1-Snow"))))
         (setq sucker snucker))
        ((setq ss (ssget "X" (list (cons 2 "KwIn1Out1"))))
         (setq sucker sucker1))
        ((setq ss (ssget "X" (list (cons 2 "Encana Contact 1in 1out"))))
         (setq sucker enco))
        ((setq ss (ssget "X" (list (cons 2 "In*Out*-Kw"))))
         (setq sucker sucker2))
        ((or (setq ss (ssget "X" (list (cons 2 "In1Out1-Rigel"))))
             (setq ss (ssget "X" (list (cons 2 "In2Out1-Rigel")))))
         (setq sucker rigsuk))
        ((or (setq ss (ssget "X" (list (cons 2 "BC Gas In1-Out1"))))
             (setq ss (ssget "X" (list (cons 2 "BC Gas In2-Out1")))))
         (setq sucker bcgsuk))
        ((setq ss (ssget "X" (list (cons 2 "IN*-OUT*"))))
         (setq sucker nusuk))
        ((or (setq ss (ssget "X" (list (cons 2 "Rangeland-In*Out*"))))
             (setq ss (ssget "X" (list (cons 2 "Rangeland Encana In*Out*")))))
         (setq sucker rrange)))
 ; Ŀ
 ;   If a width calculator was chosen then a block was found: rewidth it.  
 ; 
  (if sucker
      (progn
           (setq enam (ssname ss 0))
           (setq blscal (cdr (assoc 41 (entget enam))))
           (tentac enam blscal))
      (write-line "\nNo known SDK block found."))
 ; Ŀ
 ;   Calculate and print elapsed time.                                     
 ; 
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (prompt (strcat "\nElapsed time: " (rtos (- t2 t1) 2 1) " seconds."))
 (princ))